//********************************************************
// General Map Tasks for MAINMAP
//********************************************************

function GeneralStart::onEnter(%this)
{
  TaskModifier.strMarkVertex("GeneralTasks","GeneralStart", $TSV_CMPLETE);
  TaskModifier.strMarkVertex("GeneralTasks","TreasureFishmap", $TSV_AVAIL); 
}

/////////////////////////////////////////////////////////////////
// Treasure Map task
/////////////////////////////////////////////////////////////////

function TreasureFishmap::onExit(%this)
{
   if(firstword(getRes()) > 800)
   {
      %imagePos = "32 64";
   }
   else
   {
      %imagePos = "25 50";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/icons/parchment.png";
      iconOffset = "0 0";
      extent = "90 82";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapfound");
   tsAddTaskDialog("ID_fishmapfound", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   
   // Quest log
   tsAddQuestToTracker(false, "Treasure Hunt", "", "An old piece of paper was found in the fish's mouth. It reads, 'Find 5 cow skulls and my treasure will be yours.'", "Reward: Hopefully a lot of treasure");
   tsReadyQuest("Treasure Hunt");
   tsAddTaskToTracker("Treasure Hunt", "Find the Hidden Treasure.", "Solve the mystery of the hidden treasure.");
   tsAddTaskToTracker("Treasure Hunt", "Search for 5 cow skulls.", "Search for 5 cow skulls for more clues to the mystery.");
   
}
function Cowskullzone1::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull1zone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
   
      // Parchment Image
      if(firstword(getRes()) > 800)
      {
         %imagePos = "32 64";
      }
      else
      {
         %imagePos = "25 50";
      }
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/icons/parchment.png";
         iconOffset = "0 0";
         extent = "90 82";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapskull1");
      tsAddTaskDialog("ID_fishmapskull1", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, %charID);
      tsDestroyTaskDlgData(%dlgData);
      
      TaskModifier.strMarkVertex("GeneralTasks", "Cowskullzone1", $TSV_CMPLETE);
      %count=0;
      for(%index = 1; %index < 6; %index++)
      {
         %skullzonevertex = "Cowskullzone"@%index;
         if(%skullzonevertex.isMarkedComplete())
         {
            %count++;
         }
      }
      if(%count >= 5)
      {
         tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmapskullcomplete", $TaskButton::Okay, %charID);
         TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_AVAIL);
      }

      // Quest log
      tsReplaceTaskInTracker("Treasure Hunt", "Search for "@6-%count@" cow skulls.", "Search for "@5-%count@" cow skulls.","Search for 5 cow skulls for more clues to the mystery.");
}
function Cowskullzone2::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull2zone))
      {

         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
      
   // Parchment Image
   if(firstword(getRes()) > 800)
   {
      %imagePos = "32 64";
   }
   else
   {
      %imagePos = "25 50";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/icons/parchment.png";
      iconOffset = "0 0";
      extent = "90 82";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapskull2");
   tsAddTaskDialog("ID_fishmapskull2", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, %charID);
   tsDestroyTaskDlgData(%dlgData);
      
   TaskModifier.strMarkVertex("GeneralTasks", "Cowskullzone2", $TSV_CMPLETE);
   %count=0;
   for(%index = 1; %index < 6; %index++)
   {
      %skullzonevertex = "Cowskullzone"@%index;
      if(%skullzonevertex.isMarkedComplete())
      {
         %count++;
      }
   }
   if(%count >= 5)
   {
      tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmapskullcomplete", $TaskButton::Okay, %charID);
      TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_AVAIL);
   }
   // Quest log
   tsReplaceTaskInTracker("Treasure Hunt", "Search for "@6-%count@" cow skulls.", "Search for "@5-%count@" cow skulls.","Search for 5 cow skulls for more clues to the mystery.");
}
function Cowskullzone3::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull3zone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
       
   // Parchment Image
      if(firstword(getRes()) > 800)
      {
         %imagePos = "32 64";
      }
      else
      {
         %imagePos = "25 50";
      }
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/icons/parchment.png";
         iconOffset = "0 0";
         extent = "90 82";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapskull3");
      tsAddTaskDialog("ID_fishmapskull3", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, %charID);
      tsDestroyTaskDlgData(%dlgData);
      
      TaskModifier.strMarkVertex("GeneralTasks", "Cowskullzone3", $TSV_CMPLETE);
      %count = 0;
      for(%index = 1; %index < 6; %index++)
      {
         %skullzonevertex = "Cowskullzone"@%index;
         if(%skullzonevertex.isMarkedComplete())
         {
            %count++;
         }
      }
      if(%count >= 5)
      {
         tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmapskullcomplete", $TaskButton::Okay, %charID);
         TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_AVAIL);
      }
      // Quest log
      tsReplaceTaskInTracker("Treasure Hunt", "Search for "@6-%count@" cow skulls.", "Search for "@5-%count@" cow skulls.","Search for 5 cow skulls for more clues to the mystery.");
}
function Cowskullzone4::onExit(%this)
{
   
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull4zone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);   
   // Parchment Image
      if(firstword(getRes()) > 800)
      {
         %imagePos = "32 64";
      }
      else
      {
         %imagePos = "25 50";
      }
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/icons/parchment.png";
         iconOffset = "0 0";
         extent = "90 82";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapskull4");
      tsAddTaskDialog("ID_fishmapskull4", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, "herocharacter");
      tsDestroyTaskDlgData(%dlgData);
   
      TaskModifier.strMarkVertex("GeneralTasks", "Cowskullzone4", $TSV_CMPLETE);
      %count=0;
      for(%index = 1; %index < 6; %index++)
      {
         %skullzonevertex = "Cowskullzone"@%index;
         if(%skullzonevertex.isMarkedComplete())
         {
            %count++;
         }
      }
      if(%count >= 5)
      {
         tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmapskullcomplete", $TaskButton::Okay, %charID);
         TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_AVAIL);
      }
      // Quest log
      tsReplaceTaskInTracker("Treasure Hunt", "Search for "@6-%count@" cow skulls.", "Search for "@5-%count@" cow skulls.","Search for 5 cow skulls for more clues to the mystery.");
}
function Cowskullzone5::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull5zone))
      {
         
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);  
   
   // Parchment Image
      if(firstword(getRes()) > 800)
      {
         %imagePos = "32 64";
      }
      else
      {
         %imagePos = "25 50";
      }
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/icons/parchment.png";
         iconOffset = "0 0";
         extent = "90 82";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_Treasurehunt1", false, $TaskButton::Okay, "ID_fishmapskull5");
      tsAddTaskDialog("ID_fishmapskull5", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, %charID);
      tsDestroyTaskDlgData(%dlgData);
      
      TaskModifier.strMarkVertex("GeneralTasks", "Cowskullzone5", $TSV_CMPLETE);
      %count=0;
      for(%index = 1; %index < 6; %index++)
      {
         %skullzonevertex = "Cowskullzone"@%index;
         if(%skullzonevertex.isMarkedComplete())
         {
            %count++;
         }
      }
      if(%count >= 5)
      {
         tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmapskullcomplete", $TaskButton::Okay, %charID);
         TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_AVAIL);
      }
      // Quest log
      tsReplaceTaskInTracker("Treasure Hunt", "Search for "@6-%count@" cow skulls.", "Search for "@5-%count@" cow skulls.","Search for 5 cow skulls for more clues to the mystery.");
   
}
function Cowskullcomplete::onExit(%this)
{
   Parent::onExit(%this);
   
   // Get id of character that triggered zone
   %teamList = tsCreateObjList();
   %objList = slgGetServerCharacterList();
   %objList.getTeamList($OST_PLAYER, %teamList);
   %count = 0;
   for(%index = 0; %index < %teamList.getSize(); %index++)
   {
      %charID = %teamList.getID(%index);
      if(%charID.isInZone(cowskull5zone))
      {
         %count++;
         break;
      }
   }
   if(%count == 0){
      %charID = "herocharacter";
   }
   tsDestroyObjList(%teamList);
    
   tsSendTaskPopUpDlg("ID_Treasurehunt1", "ID_fishmaptreasure", $TaskButton::Okay, %charID);
   // Spawn a lot of treasure
   tsCreateObj("chest", "", $OST_NEUTRAL, "-229 -181");
   tsCreateObj("chest", "", $OST_NEUTRAL, "-234 -181");
   tsCreateObj("chest", "", $OST_NEUTRAL, "-229 -186");
   // Quest log
   tsCompleteTaskInTracker("Treasure Hunt", "Find the Hidden Treasure.");
   tsCompleteTaskInTracker("Treasure Hunt", "Search for 0 cow skulls.");
   
   //TaskModifier.strMarkVertex("GeneralTasks", "Cowskullcomplete", $TSV_CMPLETE);
   TaskModifier.strMarkVertex("Badgetasks", "BadgeTreasure1", $TSV_CMPLETE);
}
function CowskullfinalDialog::onExit(%this)
{
   // 1st Treasure requirement for Treasure Hunter Badge
   TaskModifier.strMarkVertex("Badgetasks", "BadgeTreasure1", $TSV_CMPLETE);
}

/////////////////////////////////////////////////////////////////
// Main Map Famine Trigger 
/////////////////////////////////////////////////////////////////

function MainmapFaminestart::onExit(%this)
{
   //Spawn Famine Character
   tsCreateObj("maleciv", "faminechar", $OST_NEUTRAL, "-202 -57", "faminechar");
   tsSkinObj("faminechar", "default");
   tsNameObj("faminechar", "Cylde Morgan");
   
}
function MainmapFamineOnCreate::onExit(%this)
{
   //Move Famine Character / Accept Dialog
   tsMoveObjToTarget("faminechar", "eastroadsign");
}
// Vertex delay to allow for reset function 
function MainmapFamineResetDelay::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_Famine", "id_famineload", $TaskButton::Accept, "faminechar", "id_famineload");
}
function LoadFamineMap::onExit(%this)
{
   Parent::onExit(%this);
   
   %scenario = new SLScenario() {
      stack   = true;
      mapName = "assets/data/missions/sandlot/famine.mis";
      mapMinimap = "assets/client/ui/minimaps/famineminimap.png";
      mapMain = false;
      
      // Resources
      resourceGold       = "0 0";
      resourceWood       = "0 0";
      resourceFood       = "50 0";
      resourceFoodMax    = "50 0";
      resourceWater      = "0 0";
      resourceWaterMax   = "0 0";
      resourceHappiness  = "80 0";
   };
   
   LoadScenario(%scenario, deactivateMainMapTasks, startFamineTasks, resetFamineTasks);
}
